@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Products</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Products List
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="example2" class="table table-striped table-hover table-bordered">
                        <thead class="thead-dark">
                            <tr>
                                <th class="wd-10p">#</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">Products Main Cate</th>
                                <th class="wd-10p">Products Parent Cate</th>
                                <th class="wd-10p">Products Child Cate</th>
                                <th class="none">Available Items</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($products as $key => $allProduct)
                                @foreach ($allProduct->subCategoriesParent as $key => $allPrantsCate)
                                    @foreach ($allPrantsCate->subCategoriesChild as $key => $allChildCate)
                                        <tr>
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $allProduct->created_at }}</td>
                                            <td>{{ $allProduct->products_category_name }}</td>
                                            <td>{{ $allPrantsCate->name }}</td>
                                            <td>{{ $allChildCate->name }}</td>
                                            <td>
                                                <table class="table table-bordered">
                                                    <tr>
                                                        <th>Truck No</th>
                                                        <th>Marka</th>
                                                        <th>Totla Available Bori</th>
                                                    </tr>
                                                    @foreach ($good_receipts_truck as $truck)
                                                        @foreach ($truck->goodReceipts as $receipts)
                                                            @foreach ($receipts->goodReceiptDetails as $receiptsDetails)
                                                                <tr>
                                                                    <td>{{ $truck->truck_no ?? null }}</td>
                                                                    <td>
                                                                        {{ $receiptsDetails->marka ?? null }}
                                                                    </td>
                                                                    <td>
                                                                        {{ $receiptsDetails->bori ?? null }}
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        @endforeach
                                                    @endforeach
                                                </table>
                                            </td>
                                        </tr>
                                    @endforeach
                                @endforeach
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">#</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">Products Main Cate</th>
                                <th class="wd-10p">Products Parent Cate</th>
                                <th class="wd-10p">Products Child Cate</th>
                                <th class="none">Available Items</th>
                            </tr>
                        </tfoot>
                    </table>

                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Product?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        @method('GET')
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        $(document).ready(function() {

            $('#example2 tfoot th').each(function() {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control" placeholder="' + title + '" />');
            });

            $('#example2').DataTable({
                "ordering": true,
                "dom": 'Blfrtip',
                "buttons": [
                    'excel', 'pdf', 'print'
                ],
                responsive: !0,
                columnDefs: [{
                    className: 'control',
                    orderable: false,
                    targets: 0
                }],
                initComplete: function() {
                    // Apply the search
                    this.api()
                        .columns()
                        .every(function() {
                            var that = this;

                            $('input', this.footer()).on('keyup change clear', function() {
                                if (that.search() !== this.value) {
                                    that.search(this.value).draw();
                                }
                            });
                        });
                }
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('good_receipts/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
